<?php
/**
 * Process Registration Form for The Lookeron School
 * Sends registration data to administration email with bot protection
 * Also stores data in session for PDF generation
 */

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session for data storage
session_start();

// Configuration
$adminEmail = "administration@thelookeronschool.co.zw";
$schoolName = "The Lookeron School";

// Bot protection checks
function isBot() {
    // Check honeypot fields
    if (!empty($_POST['website']) || !empty($_POST['honeypot_field'])) {
        return true;
    }
    
    // Check if required fields are empty
    if (empty($_POST['student_name']) || empty($_POST['email']) || empty($_POST['phone'])) {
        return true;
    }
    
    // Basic email validation
    if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        return true;
    }
    
    return false;
}

// Sanitize input
function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

// Check if form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Bot check
    if (isBot()) {
        // Silently reject bot submissions
        header("Location: ../register-online.html");
        exit();
    }
    
    // ========== STUDENT INFORMATION ==========
    $year = sanitizeInput($_POST['year'] ?? '');
    $level = sanitizeInput($_POST['level'] ?? '');
    $receiptNumber = sanitizeInput($_POST['receipt_number'] ?? '');
    $studentName = sanitizeInput($_POST['student_name'] ?? '');
    $dob = sanitizeInput($_POST['dob'] ?? '');
    $nationality = sanitizeInput($_POST['nationality'] ?? '');
    $gender = sanitizeInput($_POST['gender'] ?? '');
    $homeAddress = sanitizeInput($_POST['home_address'] ?? '');
    $phone = sanitizeInput($_POST['phone'] ?? '');
    $email = sanitizeInput($_POST['email'] ?? '');
    $previousSchool = sanitizeInput($_POST['previous_school'] ?? '');
    $previousSchoolYear = sanitizeInput($_POST['previous_school_year'] ?? '');
    $religion = sanitizeInput($_POST['religion'] ?? '');
    $modeEntry = sanitizeInput($_POST['mode_entry'] ?? '');
    
    // ========== GUARDIAN DETAILS ==========
    $guardianName = sanitizeInput($_POST['guardian_name'] ?? '');
    $guardianId = sanitizeInput($_POST['guardian_id'] ?? '');
    $guardianOccupation = sanitizeInput($_POST['guardian_occupation'] ?? '');
    $guardianWorkAddress = sanitizeInput($_POST['guardian_work_address'] ?? '');
    $guardianHomePhone = sanitizeInput($_POST['guardian_home_phone'] ?? '');
    $guardianCellPhone = sanitizeInput($_POST['guardian_cell_phone'] ?? '');
    $guardianEmergencyName = sanitizeInput($_POST['guardian_emergency_name'] ?? '');
    $guardianEmergencyPhone = sanitizeInput($_POST['guardian_emergency_phone'] ?? '');
    $guardianRelationship = sanitizeInput($_POST['guardian_relationship'] ?? '');
    $guardianAlternatePhone = sanitizeInput($_POST['guardian_alternate_phone'] ?? '');
    $guardianAddress = sanitizeInput($_POST['guardian_address'] ?? '');
    
    // ========== MOTHER'S DETAILS ==========
    $motherName = sanitizeInput($_POST['mother_name'] ?? '');
    $motherId = sanitizeInput($_POST['mother_id'] ?? '');
    $motherOccupation = sanitizeInput($_POST['mother_occupation'] ?? '');
    $motherWorkAddress = sanitizeInput($_POST['mother_work_address'] ?? '');
    $motherHomePhone = sanitizeInput($_POST['mother_home_phone'] ?? '');
    $motherCellPhone = sanitizeInput($_POST['mother_cell_phone'] ?? '');
    $motherEmergencyName = sanitizeInput($_POST['mother_emergency_name'] ?? '');
    $motherEmergencyPhone = sanitizeInput($_POST['mother_emergency_phone'] ?? '');
    $motherRelationship = sanitizeInput($_POST['mother_relationship'] ?? '');
    $motherAlternatePhone = sanitizeInput($_POST['mother_alternate_phone'] ?? '');
    $motherAddress = sanitizeInput($_POST['mother_address'] ?? '');
    
    // ========== FATHER'S DETAILS ==========
    $fatherName = sanitizeInput($_POST['father_name'] ?? '');
    $fatherId = sanitizeInput($_POST['father_id'] ?? '');
    $fatherOccupation = sanitizeInput($_POST['father_occupation'] ?? '');
    $fatherWorkAddress = sanitizeInput($_POST['father_work_address'] ?? '');
    $fatherHomePhone = sanitizeInput($_POST['father_home_phone'] ?? '');
    $fatherCellPhone = sanitizeInput($_POST['father_cell_phone'] ?? '');
    $fatherEmergencyName = sanitizeInput($_POST['father_emergency_name'] ?? '');
    $fatherEmergencyPhone = sanitizeInput($_POST['father_emergency_phone'] ?? '');
    $fatherRelationship = sanitizeInput($_POST['father_relationship'] ?? '');
    $fatherAlternatePhone = sanitizeInput($_POST['father_alternate_phone'] ?? '');
    $fatherAddress = sanitizeInput($_POST['father_address'] ?? '');
    
    // ========== REFERRAL SOURCE ==========
    $referralSource = sanitizeInput($_POST['referral_source'] ?? '');
    $referralOther = sanitizeInput($_POST['referral_other'] ?? '');
    
    // Build email subject
    $subject = "New Online Registration - " . $studentName . " - " . $level;
    
    // Submission date
    $submissionDate = date('F j, Y \a\t g:i A');
    
    // Build email body with premium HTML formatting
    $message = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Registration - {$schoolName}</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/all.min.css">
</head>
<body style="margin: 0; padding: 0; background-color: #f3f4f6; line-height: 1.6;">
    
    <!-- Main Container -->
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f3f4f6; padding: 30px 20px;">
        <tr>
            <td align="center">
                <table width="700" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);">
                    
                    <!-- Header with Gradient -->
                    <tr>
                        <td style="background: linear-gradient(135deg, #1e40af 0%, #3b82f6 50%, #0ea5e9 100%); padding: 40px 30px; text-align: center;">
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td align="center">
                                        <div style="width: 120px; height: 120px; background-color: #ffffff; border-radius: 12px; margin: 0 auto 20px; display: inline-block; line-height: 80px; font-size: 40px;">
                                            <img src="images/logo.png" alt="{$schoolName}" style="width: 100%; height: auto;">
                                        </div>
                                        <h1 style="color: #ffffff; margin: 0; font-size: 28px; font-weight: 700; letter-spacing: 1px;">{$schoolName}</h1>
                                        <p style="color: rgba(255, 255, 255, 0.9); margin: 10px 0 0; font-size: 16px;">New Online Registration Submission</p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td style="padding: 30px;">
                            
                            <!-- Student Information Section -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #3b82f6; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #1e40af; margin: 0 0 15px; font-size: 18px;">
                                           <i class="fa-solid fa-user"></i> Student Information
                                        </h3>
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr><td style="color: #6b7280; font-weight: 600; width: 40%;">Year:</td><td style="color: #1f2937;">{$year}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Level/Grade:</td><td style="color: #1f2937;">{$level}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Receipt Number:</td><td style="color: #1f2937;">{$receiptNumber}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Full Name:</td><td style="color: #1f2937; ">{$studentName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Date of Birth:</td><td style="color: #1f2937;">{$dob}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Nationality:</td><td style="color: #1f2937;">{$nationality}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Gender:</td><td style="color: #1f2937;">{$gender}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Home Address:</td><td style="color: #1f2937;">{$homeAddress}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Phone Number:</td><td style="color: #1f2937;">{$phone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Email:</td><td style="color: #3b82f6;">{$email}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Previous School:</td><td style="color: #1f2937;">{$previousSchool}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Previous Year:</td><td style="color: #1f2937;">{$previousSchoolYear}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Religion:</td><td style="color: #1f2937;">{$religion}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Mode of Entry:</td><td style="color: #1f2937;"><span style="background: #dbeafe; color: #1e40af; padding: 3px 10px; border-radius: 12px; font-size: 12px; font-weight: 600;">{$modeEntry}</span></td></tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Guardian Section -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #10b981; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #059669; margin: 0 0 15px; font-size: 18px;">
                                            <i class="fa-solid fa-user"></i> Guardian Details (Primary Contact)
                                        </h3>
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr><td style="color: #6b7280; font-weight: 600; width: 40%;">Guardian Name:</td><td style="color: #1f2937;">{$guardianName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">ID Number:</td><td style="color: #1f2937;">{$guardianId}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Occupation:</td><td style="color: #1f2937;">{$guardianOccupation}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Work Address:</td><td style="color: #1f2937;">{$guardianWorkAddress}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Home Phone:</td><td style="color: #1f2937;">{$guardianHomePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Cell Phone:</td><td style="color: #1f2937;">{$guardianCellPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Contact:</td><td style="color: #1f2937;">{$guardianEmergencyName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Phone:</td><td style="color: #dc2626;">{$guardianEmergencyPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Relationship:</td><td style="color: #1f2937;">{$guardianRelationship}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Alternate Phone:</td><td style="color: #1f2937;">{$guardianAlternatePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Residential Address:</td><td style="color: #1f2937;">{$guardianAddress}</td></tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Mother Section -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #ec4899; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #db2777; margin: 0 0 15px; font-size: 18px;">
                                            <i class="fa-solid fa-user"></i> Mother's Details
                                        </h3>
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr><td style="color: #6b7280; font-weight: 600; width: 40%;">Mother's Name:</td><td style="color: #1f2937;">{$motherName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">ID Number:</td><td style="color: #1f2937;">{$motherId}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Occupation:</td><td style="color: #1f2937;">{$motherOccupation}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Work Address:</td><td style="color: #1f2937;">{$motherWorkAddress}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Home Phone:</td><td style="color: #1f2937;">{$motherHomePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Cell Phone:</td><td style="color: #1f2937;">{$motherCellPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Contact:</td><td style="color: #1f2937;">{$motherEmergencyName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Phone:</td><td style="color: #dc2626;">{$motherEmergencyPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Alternate Phone:</td><td style="color: #1f2937;">{$motherAlternatePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Residential Address:</td><td style="color: #1f2937;">{$motherAddress}</td></tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Father Section -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #8b5cf6; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #7c3aed; margin: 0 0 15px; font-size: 18px;">
                                            <i class="fa-solid fa-user"></i> Father's Details
                                        </h3>
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr><td style="color: #6b7280; font-weight: 600; width: 40%;">Father's Name:</td><td style="color: #1f2937;">{$fatherName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">ID Number:</td><td style="color: #1f2937;">{$fatherId}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Occupation:</td><td style="color: #1f2937;">{$fatherOccupation}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Work Address:</td><td style="color: #1f2937;">{$fatherWorkAddress}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Home Phone:</td><td style="color: #1f2937;">{$fatherHomePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Cell Phone:</td><td style="color: #1f2937;">{$fatherCellPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Contact:</td><td style="color: #1f2937;">{$fatherEmergencyName}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Emergency Phone:</td><td style="color: #dc2626;">{$fatherEmergencyPhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Alternate Phone:</td><td style="color: #1f2937;">{$fatherAlternatePhone}</td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Residential Address:</td><td style="color: #1f2937;">{$fatherAddress}</td></tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Referral Section -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #f59e0b; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #d97706; margin: 0 0 15px; font-size: 18px;">
                                            <i class="fa-solid fa-bullhorn"></i> Referral Information
                                        </h3>
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr><td style="color: #6b7280; font-weight: 600; width: 50%;">How They Heard About Us:</td><td style="color: #1f2937;"><span style="background: #fef3c7; color: #92400e; padding: 3px 10px; border-radius: 12px; font-size: 12px; font-weight: 600;">{$referralSource}</span></td></tr>
                                            <tr><td style="color: #6b7280; font-weight: 600;">Other Details:</td><td style="color: #1f2937;">{$referralOther}</td></tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #1e293b; padding: 30px; text-align: center;">
                            <p style="color: rgba(255, 255, 255, 0.7); margin: 0 0 10px; font-size: 13px;">
                                This registration was submitted on <strong style="color: #ffffff;">{$submissionDate}</strong>
                            </p>
                            <p style="color: #ffffff; margin: 0 0 5px; font-size: 15px; font-weight: 600;">{$schoolName}</p>
                            <p style="color: rgba(255, 255, 255, 0.7); margin: 0 0 5px; font-size: 12px;">Stand Number 4, Southlea Park, Harare, Zimbabwe</p>
                            <p style="color: #3b82f6; margin: 0; font-size: 13px; font-weight: 600;">+263 777 225 812 | +263 777 225 816</p>
                        </td>
                    </tr>
                    
                </table>
                
                <!-- Bottom text -->
                <p style="color: #9ca3af; font-size: 11px; text-align: center; margin-top: 20px;">
                    This is an automated email from the school registration system. Please do not reply to this email.
                </p>
            </td>
        </tr>
    </table>
    
</body>
</html>
HTML;
    
    // Email headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: $schoolName <noreply@thelookeronschool.co.zw>" . "\r\n";
    $headers .= "Reply-To: $email" . "\r\n";
    
    // Send email (suppress errors on local server)
    $mailSent = @mail($adminEmail, $subject, $message, $headers);
    
    // Log email status (for debugging)
    if (!$mailSent) {
        error_log("Email sending failed for registration: " . $studentName . " - This is normal on local server without SMTP configuration.");
    }
    
    // Store all form data in session for PDF generation
    $_SESSION['registration_data'] = [
        // Student Information
        'year' => $year,
        'level' => $level,
        'receipt_number' => $receiptNumber,
        'student_name' => $studentName,
        'dob' => $dob,
        'nationality' => $nationality,
        'gender' => $gender,
        'home_address' => $homeAddress,
        'phone' => $phone,
        'email' => $email,
        'previous_school' => $previousSchool,
        'previous_school_year' => $previousSchoolYear,
        'religion' => $religion,
        'mode_entry' => $modeEntry,
        
        // Guardian Details
        'guardian_name' => $guardianName,
        'guardian_id' => $guardianId,
        'guardian_occupation' => $guardianOccupation,
        'guardian_work_address' => $guardianWorkAddress,
        'guardian_home_phone' => $guardianHomePhone,
        'guardian_cell_phone' => $guardianCellPhone,
        'guardian_emergency_name' => $guardianEmergencyName,
        'guardian_emergency_phone' => $guardianEmergencyPhone,
        'guardian_relationship' => $guardianRelationship,
        'guardian_alternate_phone' => $guardianAlternatePhone,
        'guardian_address' => $guardianAddress,
        
        // Mother's Details
        'mother_name' => $motherName,
        'mother_id' => $motherId,
        'mother_occupation' => $motherOccupation,
        'mother_work_address' => $motherWorkAddress,
        'mother_home_phone' => $motherHomePhone,
        'mother_cell_phone' => $motherCellPhone,
        'mother_emergency_name' => $motherEmergencyName,
        'mother_emergency_phone' => $motherEmergencyPhone,
        'mother_relationship' => $motherRelationship,
        'mother_alternate_phone' => $motherAlternatePhone,
        'mother_address' => $motherAddress,
        
        // Father's Details
        'father_name' => $fatherName,
        'father_id' => $fatherId,
        'father_occupation' => $fatherOccupation,
        'father_work_address' => $fatherWorkAddress,
        'father_home_phone' => $fatherHomePhone,
        'father_cell_phone' => $fatherCellPhone,
        'father_emergency_name' => $fatherEmergencyName,
        'father_emergency_phone' => $fatherEmergencyPhone,
        'father_relationship' => $fatherRelationship,
        'father_alternate_phone' => $fatherAlternatePhone,
        'father_address' => $fatherAddress,
        
        // Referral
        'referral_source' => $referralSource,
        'referral_other' => $referralOther
    ];
    
    // Redirect to thank you page with PDF download option
    header("Location: ../pages/registration-success.html");
    exit();
    
} else {
    // If not POST, redirect to form
    header("Location: ../register-online.html");
    exit();
}
?>
