﻿<?php
/**
 * Contact Form Email Handler for The Lookeron School
 * Sends contact form submissions to administration email
 */

// Configuration
$to = 'administration@thelookeronschool.co.zw';
$schoolName = 'The Lookeron School';

// Bot protection - check honeypot
if (!empty($_POST['website_url'])) {
    // Bot detected, silently fail
    header('Location: ../contact.html');
    exit();
}

function url() {
    return sprintf(
        "%s://%s",
        isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
        $_SERVER['SERVER_NAME']
    );
}

function sanitize($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $name = sanitize($_POST['name'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $subject = sanitize($_POST['subject'] ?? '');
    $contact_message = sanitize($_POST['message'] ?? '');
    
    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header('Location: ../contact.html?error=invalid_email');
        exit();
    }
    
    // Check required fields
    if (empty($name) || empty($email) || empty($contact_message)) {
        header('Location: ../contact.html?error=required_fields');
        exit();
    }
    
    // Set default subject if empty
    if (empty($subject)) {
        $subject = "Contact Form Submission from " . $name;
    }
    
    // Submission date
    $submissionDate = date('F j, Y \a\t g:i A');
    
    // Build HTML email message with premium styling
    $message = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Contact - {$schoolName}</title>
</head>
<body style="margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f3f4f6; line-height: 1.6;">
    
    <!-- Main Container -->
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f3f4f6; padding: 30px 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);">
                    
                    <!-- Header with Gradient -->
                    <tr>
                        <td style="background: linear-gradient(135deg, #1e40af 0%, #3b82f6 50%, #0ea5e9 100%); padding: 40px 30px; text-align: center;">
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td align="center">
                                        <div style="width: 100px; height: 100px; background-color: #ffffff; border-radius: 12px; margin: 0 auto 20px; display: inline-block; padding: 10px;">
                                            <img src="https://thelookeronschool.co.zw/images/logo.png" alt="{$schoolName}" style="width: 100%; height: auto;">
                                        </div>
                                        <h1 style="color: #ffffff; margin: 0; font-size: 26px; font-weight: 700; letter-spacing: 1px;">{$schoolName}</h1>
                                        <p style="color: rgba(255, 255, 255, 0.9); margin: 10px 0 0; font-size: 16px;">📬 New Contact Form Submission</p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td style="padding: 30px;">
                            
                            <!-- Sender Information -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; margin-bottom: 20px; border-left: 4px solid #3b82f6; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #1e40af; margin: 0 0 15px; font-size: 18px;">
                                             Sender Information
                                        </h3>
                                        <table width="100%" cellpadding="8" cellspacing="0">
                                            <tr>
                                                <td style="color: #6b7280; font-weight: 600; width: 30%;">Name:</td>
                                                <td style="color: #1f2937; font-weight: 700;">{$name}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #6b7280; font-weight: 600;">Email:</td>
                                                <td><a href="mailto:{$email}" style="color: #3b82f6; text-decoration: none; font-weight: 600;">{$email}</a></td>
                                            </tr>
                                            <tr>
                                                <td style="color: #6b7280; font-weight: 600;">Subject:</td>
                                                <td style="color: #1f2937;"><span style="background: #dbeafe; color: #1e40af; padding: 4px 12px; border-radius: 15px; font-size: 13px; font-weight: 600;">{$subject}</span></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Message Content -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f9fafb; border-radius: 12px; border-left: 4px solid #10b981; overflow: hidden;">
                                <tr>
                                    <td style="padding: 20px 25px;">
                                        <h3 style="color: #059669; margin: 0 0 15px; font-size: 18px;">
                                             Message
                                        </h3>
                                        <div style="background: #ffffff; padding: 20px; border-radius: 8px; border: 1px solid #e5e7eb;">
                                            <p style="color: #374151; margin: 0; font-size: 15px; line-height: 1.8;">
HTML;
    $message .= nl2br(htmlspecialchars($contact_message));
    $message .= <<<HTML
                                            </p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Reply Button -->
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 25px;">
                                <tr>
                                    <td align="center">
                                        <a href="mailto:{$email}?subject=Re: {$subject}" style="display: inline-block; background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%); color: #ffffff; padding: 14px 35px; border-radius: 30px; text-decoration: none; font-weight: 600; font-size: 15px; box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);">
                                             Reply to {$name}
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #1e293b; padding: 25px; text-align: center;">
                            <p style="color: rgba(255, 255, 255, 0.7); margin: 0 0 8px; font-size: 12px;">
                                This message was sent from the contact form on your website
                            </p>
                            <p style="color: rgba(255, 255, 255, 0.7); margin: 0 0 12px; font-size: 13px;">
                                Received on <strong style="color: #ffffff;">{$submissionDate}</strong>
                            </p>
                            <p style="color: #ffffff; margin: 0 0 5px; font-size: 14px; font-weight: 600;">{$schoolName}</p>
                            <p style="color: rgba(255, 255, 255, 0.6); margin: 0 0 5px; font-size: 11px;">Stand Number 4, Southlea Park, Harare, Zimbabwe</p>
                            <p style="color: #3b82f6; margin: 0; font-size: 12px; font-weight: 600;">+263 777 225 812 | +263 777 225 816</p>
                        </td>
                    </tr>
                    
                </table>
                
                <!-- Bottom text -->
                <p style="color: #9ca3af; font-size: 11px; text-align: center; margin-top: 20px;">
                    This is an automated email from the school contact system.
                </p>
            </td>
        </tr>
    </table>
    
</body>
</html>
HTML;
    
    // Email Headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: $schoolName <noreply@thelookeronschool.co.zw>" . "\r\n";
    $headers .= "Reply-To: $email" . "\r\n";
    
    // For Windows server
    ini_set("sendmail_from", $to);
    
    // Send email
    $mailSent = mail($to, $subject, $message, $headers);
    
    if ($mailSent) {
        // Redirect with success message
        header('Location: ../pages/contact-success.html');
        exit();
    } else {
        // Redirect with error
        header('Location: ../contact.html?error=send_failed');
        exit();
    }
} else {
    // If not POST, redirect to contact page
    header('Location: ../contact.html');
    exit();
}
?>